// priority: 28

global.失乐园配置 = {
    // 饰品的注册ID
    饰品ID: "kubejs:shileyuan",
    // 用于在饰品NBT中存储有效食物层数的键名
    NBT层数: "shileyuan_food_count",
    // 用于在玩家pdata中缓存上一次食物总数的键名
    pdata: "shileyuan_last_count",
    // 没有任何层数时的基础伤害减少百分比 (30%)
    基础伤害惩罚: 0.30,
    // 每吃一种新食物提供的伤害加成百分比 (0.5%)
    每层伤害加成: 0.005,
    // 食物恢复的饱食度必须大于此值才算有效
    最小有效饱食度: 2
};

let 查找失乐园戒指 = (p) => {
    if (!p) return null;
    let 饰品主处理器结果 = $饰品.getCuriosInventory(p);
    if (!饰品主处理器结果 || !饰品主处理器结果.resolve().isPresent()) return null;
    let 饰品真实处理器 = 饰品主处理器结果.resolve().get();
    let 查找结果 = 饰品真实处理器.findFirstCurio(global.失乐园配置.饰品ID);
    return 查找结果.isPresent() ? 查找结果.get() : null;
};

let 计算并同步失乐园计数 = (p) => {
    let 戒指结果 = 查找失乐园戒指(p);
    if (!戒指结果) return;
    let 饰品堆栈 = 戒指结果.stack();
    let 食物能力 = $食物列表类.get(p);
    if (食物能力) {
        let 已吃食物集合 = 食物能力.getEatenFoods();
        let 有效食物计数 = 0;
        for (let 食物实例 of 已吃食物集合) {
            let 物品 = 食物实例.item;
            let 食物属性 = 物品.getFoodProperties();
            if (食物属性 && 食物属性.getNutrition() > global.失乐园配置.最小有效饱食度) {
                有效食物计数++;
            }
        }
        饰品堆栈.getOrCreateTag().putInt(global.失乐园配置.NBT层数, 有效食物计数);
    }
};

NativeEvents.onEvent(Java.loadClass("top.theillusivec4.curios.api.event.CurioChangeEvent"), e => {
    let p = e.getEntity();
    if (!p || !(p instanceof $玩家) || p.level.isClientSide()) return;
    
    if (e.to.id === global.失乐园配置.饰品ID) {
        计算并同步失乐园计数(p);
        let 食物能力 = $食物列表类.get(p);
        if (食物能力) p.persistentData.putInt(global.失乐园配置.pdata, 食物能力.getEatenFoods().size());
    } 
    else if (e.from.id === global.失乐园配置.饰品ID) {
        p.persistentData.remove(global.失乐园配置.pdata);
    }
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Finish"), e => {
    let p = e.getEntity();
    if (!p || !(p instanceof $玩家) || p.level.isClientSide()) return;
    if (!e.getItem().isEdible()) return;
    if (!查找失乐园戒指(p)) return;
    
    let 新总数 = $食物列表类.get(p).getEatenFoods().size();
    let 旧总数 = p.persistentData.getInt(global.失乐园配置.pdata);
    
    if (新总数 > 旧总数) {
        计算并同步失乐园计数(p);
        let 物品 = e.getItem().item;
        let 食物属性 = 物品.getFoodProperties();
        if(食物属性 && 食物属性.getNutrition() > global.失乐园配置.最小有效饱食度) {
            p.tell(Component.translate("kubejs.message.food_eaten.enhance"));
        }
        p.persistentData.putInt(global.失乐园配置.pdata, 新总数);
    }
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingHurtEvent"), e => {
    let 攻击者 = e.source.player;
    if (攻击者 && !攻击者.isFake()) {
        let 戒指结果 = 查找失乐园戒指(攻击者);
        if (戒指结果) {
            let 原始伤害 = e.amount;
            let 标签 = 戒指结果.stack().getOrCreateTag();
            let 食物计数 = 标签.getInt(global.失乐园配置.NBT层数);
            let 最终伤害系数 = 1 - global.失乐园配置.基础伤害惩罚 + (食物计数 * global.失乐园配置.每层伤害加成);
            let 计算后伤害 = 原始伤害 * 最终伤害系数;
            if (Math.abs(计算后伤害 - 原始伤害) > 0.001) {
                if (计算后伤害 < 0) 计算后伤害 = 0;
                e.setAmount(计算后伤害);
            }
        }
    }
});